using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.AHOBPR.BO;

namespace VIRP.AHOBPR.DAL
{
	public partial class QUEUE_STATUSDB : VIRP.DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public QUEUE_STATUSDB()
		{
		}

		#endregion

		#region Properties
		#endregion

		#region Methods

		public QUEUE_STATUS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int64 QUEUE_STATUS_ID)
		{
			QUEUE_STATUS objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_QUEUE_STATUS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, QUEUE_STATUS_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<QUEUE_STATUS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<QUEUE_STATUS> objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_QUEUE_STATUS_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public Int64 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, QUEUE_STATUS objSave)
		{
			Int64? objReturn = objSave.QUEUE_STATUS_ID;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_QUEUE_STATUS_save(CURRENT_USER, CURRENT_REGISTRY_ID, DateTime.Now, objSave.CREATEDBY, objSave.PROCESS_COMPLETE_DATE, objSave.PROCESS_DESCRIPTION, objSave.PROCESS_ERROR, objSave.PROCESS_START_DATE, objSave.PROCESS_STATUS, objSave.QUEUE_ID, ref objReturn, objSave.REGISTRANT_ID, DateTime.Now, objSave.UPDATEDBY, objSave.USER_ID);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int64 QUEUE_STATUS_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_QUEUE_STATUS_delete(CURRENT_USER, CURRENT_REGISTRY_ID, QUEUE_STATUS_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public List<QUEUE_LITE> GetQueue(string queuebatchid)
        {
            List<QUEUE_LITE> objReturn = null;

            try
            {
                using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    objReturn = dbContext.SP_ProcessQueueBatch(Convert.ToInt32(queuebatchid)).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;

            //List<QUEUE_LITE> queue = new List<QUEUE_LITE>();
            //try
            //{
            //    Dictionary<String, Object> param = new Dictionary<string, object>();
            //    param.Add("@queueBatchId", Convert.ToInt32(queuebatchid));
            //    List<Object[]> rows = DbUtil.ExecuteSProc("AHOBPR.SP_ProcessQueueBatch", param);
            //    if (rows.Count == 0)
            //    {
            //        return queue;
            //    }
            //    foreach (object[] rowItem in rows)
            //    {
            //        QUEUE_LITE queueItem = new QUEUE_LITE()
            //        {
            //            QUEUE_ID = long.Parse(rowItem[0].ToString()),
            //            REGISTRANT_ID = string.IsNullOrEmpty(rowItem[1].ToString()) ? 0 : int.Parse(rowItem[1].ToString()),
            //            USER_ID = string.IsNullOrEmpty(rowItem[2].ToString()) ? 0 : int.Parse(rowItem[2].ToString()),
            //            QUEUE_TYPE = rowItem[3].ToString(),
            //            ITEM_ID = int.Parse(rowItem[4].ToString()),
            //            ITEM_DESCRIPTION = rowItem[5].ToString(),
            //            CREATEDBY = rowItem[6].ToString()
            //        };
            //        queue.Add(queueItem);

            //    }
            //}
            //catch (Exception ex)
            //{
            //    _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
            //}
            //return queue;
        }

        #endregion
    }
}
